use master
GO

set nocount on 

--set to 0 to skip updating the A4Survey_Client_Template database, or to 1 to update the template database
declare @ProcessTemplateDB bit = 1  

declare @ClientPayload01 nvarchar(max) = N'
-- DEV-74446 183822
IF EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N''[VX_sp_GetVariablesByPosition]'') AND type in (N''P'', N''PC''))
   DROP PROCEDURE [dbo].[VX_sp_GetVariablesByPosition]
'

declare @ClientPayload02 nvarchar(max) = N'
CREATE PROCEDURE [dbo].[VX_sp_GetVariablesByPosition]
 @iQuestionnaireId int,
 @showSystem bit = 0,
 @onlySystem bit = 0,
 @onlyOpenEnds bit = 0,
 @selected nvarchar(max) = '''',
 @excludeSelected bit = 0,
 @search NVARCHAR(255) = '''',
 @sort NVARCHAR(255) = '''',
 @startIndex INT = 1,
 @endIndex INT = 10,
 @language VARCHAR(10) = ''en''
AS
BEGIN
 SET NOCOUNT ON
 
 DECLARE @innerQuery nvarchar(max) 
 DECLARE @stmt nvarchar(max) 
 DECLARE @reportingDbName  nvarchar(64) = replace(DB_NAME(), ''Survey'', ''Reporting'')

 IF (@sort IS NULL OR LEN(@sort) <= 0 ) SET @sort = ''Position''
 
 SET @innerQuery = '' (
 SELECT Id,
        ROW_NUMBER() OVER (ORDER BY BlockPosition, QuestionPosition, ColPos, RowPos) AS [Position],
        Name,
        DisplayName,
        QuestionName,
        Text,
        QuestionPosition,
        BlockName,
        BlockPosition,
        OpenEnd,
        ColPos,
        RowPos,
        IsPII
 FROM
 (SELECT Id, Name, DisplayName, ''''System'''' as QuestionName, '''''''' as Text, 0 as QuestionPosition, '''''''' as BlockName, 0 as BlockPosition, 0 as OpenEnd, 0 as ColPos, 0 as RowPos, IsPII
 FROM dbo.SystemVariables
 WHERE 1 = @showSystem AND @onlyOpenEnds = 0 AND Language = @language
 UNION
 SELECT v.Id, v.Name, v.Name as DisplayName, q.Name, IsNull(lt.Text, ''''''''), bi.Position, b.Name, b.Position, v.HasOpenEnd,IsNull(c.Position, 0) as ColPos, IsNull(r.Position, 0) as RowPos,
 CAST((CASE WHEN CHARINDEX(v.Name, so.PIIVariables) > 0 THEN 1 ELSE 0 END) AS BIT) as IsPII
 FROM SAT.Variables AS v 
 INNER JOIN SAT.BlockItems_Question AS q ON q.Id = v.QuestionId and q.Version = 0 and q.Type_Id != 36
 INNER JOIN SAT.BlockItems AS bi ON bi.Id = v.QuestionId and bi.Version = 0
 INNER JOIN SAT.Blocks as b ON bi.BlockId = b.Id and b.Version = 0
 INNER JOIN SAT.SurveyOptions so ON b.QuestionnaireId = so.Id and so.Version = 0
 LEFT JOIN (SAT.LocalizableTexts_QuestionText as qt
 INNER JOIN SAT.LocalizableTexts as lt ON lt.Id = qt.Id and lt.Version = 0)
 ON qt.QuestionId = bi.Id and qt.Version = 0 AND lt.Language = so.DefaultLanguage
 LEFT JOIN '' + @reportingDbName + ''.dbo.Variables as rv ON rv.SourceKey = v.Id AND rv.Name = v.Name AND rv.SourceId = 1
 LEFT JOIN '' + @reportingDbName + ''.dbo.Columns as c ON c.Id = rv.ColumnId
 LEFT JOIN '' + @reportingDbName + ''.dbo.Rows as r ON r.Id = rv.RowId
 WHERE @onlySystem = 0 AND b.QuestionnaireId = @iQuestionnaireId AND v.Version = 0
        AND (@onlyOpenEnds = 0 OR v.HasOpenEnd = 1)) subquery ) topquery''
 
 DECLARE @stmtSelection nvarchar(max) = '''' 
 
 IF (@selected <> '''')
 BEGIN
  SET @stmtSelection = '' Name '' + (CASE WHEN @excludeSelected = 1 THEN ''NOT'' ELSE '''' END) + '' IN ('' + @selected + '') AND ''
 END
 
 Set @stmt = ''
  SELECT * FROM
  (SELECT ROW_NUMBER() OVER (ORDER BY '' + @sort + '') AS [RowNum], * 
  FROM '' + @innerQuery + '' WHERE '' + @stmtSelection + '' (Name LIKE ''''%'' + @search + ''%'''' OR Text LIKE ''''%'' + @search + ''%'''')) rowquery
  WHERE [RowNum] >= @startIndex AND [RowNum] <= @endIndex
  ORDER BY [RowNum]''

 EXEC sp_executesql @stmt, N''@iQuestionnaireId INT, @showSystem BIT, @onlySystem BIT, @onlyOpenEnds BIT, @language VARCHAR(10), @startIndex INT, @endIndex INT'', @iQuestionnaireId, @showSystem, @onlySystem, @onlyOpenEnds, @language, @startIndex, @endIndex

 SET @stmt = ''SELECT COUNT(*) AS [TotalRecords] FROM '' + @innerQuery + '' WHERE '' + @stmtSelection + '' (Name LIKE ''''%'' + @search + ''%'''' OR Text LIKE ''''%'' + @search + ''%'''')''
 EXEC sp_executesql @stmt, N''@iQuestionnaireId INT, @showSystem BIT, @onlySystem BIT, @onlyOpenEnds BIT, @language VARCHAR(10)'', @iQuestionnaireId, @showSystem, @onlySystem, @onlyOpenEnds, @language
 
END
'

create table #DB (
	DBName nvarchar(128),
	Processed tinyint default 0
)
create table #Survey (
	DBName nvarchar(128),
	SchemaName nvarchar(128),
	Processed tinyint default 0
)
create table #SurveyVerif (
	DBName nvarchar(128),
	SchemaName nvarchar(128)
)
create table #SurveysDone (
	DBName nvarchar(128) collate database_default,
	SchemaName nvarchar(128) collate database_default
)
declare @AllDone bit = 0, 
        @TotalClients int, 
		@TotalSurveys int, 
		@ClientCounter int, 
		@SurveyCounter int, 
		@ThisClient nvarchar(128), 
		@ThisSurvey nvarchar(128), 
		@ClientCursor cursor, 
		@SurveyCursor cursor, 
		@DBSQL nvarchar(200), 
		@SQL nvarchar(max), 
		@StatusMessage varchar(max), 
		@StatusPercent tinyint

while @AllDone = 0 begin
	select @TotalClients = 0, @TotalSurveys = 0, @ClientCounter = 0, @SurveyCounter = 0
	insert into #DB 
	select 'A4Survey_Client_' + cast(Id as nvarchar(16)), 0 from Acuity4.dbo.Client
	     
    if @ProcessTemplateDB = 1 
	   insert into #DB values (N'A4Survey_Client_Template', 0)

	select @TotalClients = count(*) 
	       from #DB
	
	set @ClientCursor = cursor scroll dynamic for select DBName from #DB for update of Processed
	open @ClientCursor
	fetch next from @ClientCursor into @ThisClient
	while @@FETCH_STATUS = 0 begin
		select @ClientCounter += 1
		select @DBSQL = @ThisClient + N'.sys.sp_executesql'
		select @SQL = N'insert into #Survey select ''' + @ThisClient + ''', SchemaName, 0 from ' + @ThisClient + '.dbo.Survey except select DBName, SchemaName, 0 from #SurveysDone'
		exec @DBSQL @SQL
		select @StatusMessage = 'Updating client database "%s" (%u of %u, %u%%)', @StatusPercent = 100.0 * @ClientCounter / @TotalClients
		raiserror (@StatusMessage, 0, 1, @ThisClient, @ClientCounter, @TotalClients, @StatusPercent) with nowait
		
		select @SQL = replace(replace(@ClientPayload01, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		select @SQL = replace(replace(@ClientPayload02, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		update #DB set Processed = 1 where current of @ClientCursor
		fetch next from @ClientCursor into @ThisClient
	end


	close @ClientCursor
	deallocate @ClientCursor

-- Backup client template db if it was updated
	IF @ProcessTemplateDB = 1 
    BEGIN
      PRINT 'Creating backup for A4Survey_Client_Template';
      SET @SQL = 'USE Acuity4;
                  exec [dbo].[VX_sp_BackupClientTemplateDatabase]'
      EXEC (@SQL); 
    END

    SELECT @AllDone = 1
end



--select * from #DB
--select * from #Survey

drop table #DB
drop table #Survey
drop table #SurveyVerif
drop table #SurveysDone